//
//  MCPOutlineViewDataSource.h
//  MCApplication
//
//  Created by Ali Lalani on 7/26/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCTableView.h"

@class MCPDatabaseObjectContext;

@interface MCPOutlineViewDataSource : NSObject {
	NSString *childrenKey; // keypath leading to the array of sub-objects, i.e. subTasks
	NSString *childrenCountKey;
	NSString *hasChildrenKey;
	NSString *parentKey; // keypath leading to the parent object
	
	NSString *pasteboardType;
	
	// The master array of objects to fill the outline view
	NSArray *results;

	BOOL _needsSort;
	BOOL _isSorting;
	
	NSString *sortIdentifier;
	NSString *sortKey;
	BOOL sortKeyAscending;

	NSArray *sortDescriptors;
	
	MCPDatabaseObjectContext *objectContext;
}
- (void)sortResults;

#pragma mark Accessors
- (NSArray *)results;
- (void)setResults:(NSArray *)aResults;

- (NSString *)pasteboardType;
- (void)setPasteboardType:(NSString *)aPasteboardType;

- (NSString *)childrenKey;
- (void)setChildrenKey:(NSString *)aChildrenKey;
- (NSString *)childrenCountKey;
- (void)setChildrenCountKey:(NSString *)aChildrenCountKey;
- (NSString *)hasChildrenKey;
- (void)setHasChildrenKey:(NSString *)aHasChildrenKey;
- (NSString *)parentKey;
- (void)setParentKey:(NSString *)aParentKey;
- (MCPDatabaseObjectContext *)objectContext;
- (void)setObjectContext:(MCPDatabaseObjectContext *)anObjectContext;

- (NSString *)sortIdentifier;
- (void)setSortIdentifier:(NSString *)aSortIdentifier;
- (NSString *)sortKey;
- (void)setSortKey:(NSString *)aSortKey;
- (BOOL)sortKeyAscending;
- (void)setSortKeyAscending:(BOOL)flag;

- (NSArray *)sortDescriptors;
- (void)setSortDescriptors:(NSArray *)aSortDescriptors;
@end
